<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = strtoupper($_POST['name']);
    $stmt = $pdo->prepare("INSERT INTO brands (name, created_at) VALUES (?, NOW())");
    $stmt->execute([$name]);
    header("Location: marcas.php");
    exit;
}

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
?>

<main class="flex-1 p-8">
    <div class="max-w-2xl mx-auto">
        <div class="flex items-center gap-4 mb-8">
            <a href="marcas.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-colors shadow-sm">
                <i class="ri-arrow-left-line text-xl"></i>
            </a>
            <h1 class="font-display font-black text-3xl dark:text-white uppercase">Nueva Marca</h1>
        </div>

        <form method="POST" class="bg-white dark:bg-brand-dark p-8 rounded-xl border border-gray-100 dark:border-white/5 space-y-6 shadow-xl">
            <div>
                <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Nombre de la Marca</label>
                <input type="text" name="name" required placeholder="Ej: PIONEER DJ" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 dark:text-white focus:border-brand-red outline-none">
            </div>

            <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-bold uppercase py-4 rounded-xl shadow-lg transition-all transform active:scale-95">
                Registrar Marca
            </button>
        </form>
    </div>
</main>

<?php require_once 'includes/footer.php'; ?>